VERSION 5.00
Begin VB.Form fmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Rigol Upgrade from DS1052E to DS1102E"
   ClientHeight    =   2025
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   7965
   Icon            =   "fmMain.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   ScaleHeight     =   2025
   ScaleWidth      =   7965
   StartUpPosition =   2  'CenterScreen
   Begin VB.TextBox modSerial 
      Height          =   285
      Left            =   3360
      TabIndex        =   6
      Text            =   "DS1EB111202114"
      Top             =   1440
      Width           =   4305
   End
   Begin VB.TextBox modModel 
      Height          =   285
      Left            =   3360
      TabIndex        =   4
      Text            =   "DS1102E"
      Top             =   1110
      Width           =   4305
   End
   Begin VB.CommandButton cmdMod 
      Caption         =   "Upgrade Rigol"
      Height          =   615
      Left            =   240
      TabIndex        =   2
      Top             =   1080
      Width           =   2415
   End
   Begin VB.TextBox txtModel 
      Height          =   615
      Left            =   2910
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      TabIndex        =   1
      Top             =   240
      Width           =   4755
   End
   Begin VB.CommandButton cmdSerial 
      Caption         =   "Check Rigol Model && Serial"
      Height          =   615
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   2415
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Serial"
      Height          =   195
      Left            =   2895
      TabIndex        =   5
      Top             =   1470
      Width           =   390
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Model"
      Height          =   195
      Left            =   2850
      TabIndex        =   3
      Top             =   1140
      Width           =   435
   End
End
Attribute VB_Name = "fmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const rigBufSize As Long = 10000

Private Sub Form_Load()
    modModel = ""
    modSerial = ""
End Sub

Private Sub cmdSerial_Click()
    Dim dat As String
    Dim model As String
    Dim serial As String
    Dim j As Long

    dat = SendRigolCommand("*IDN?", -1)
    txtModel = dat

    'remove company name
    j = InStr(1, dat, ",", vbBinaryCompare)
    If j <= 0 Then GoTo Ending
    dat = Right(dat, Len(dat) - j)

    'get model name
    j = InStr(1, dat, ",", vbBinaryCompare)
    If j <= 0 Then GoTo Ending
    model = Left(dat, j - 1)
    dat = Right(dat, Len(dat) - j)

    'set modified model
    model = "DS1102E"
    modModel = model
 
    'get serial number
    j = InStr(1, dat, ",", vbBinaryCompare)
    If j <= 0 Then GoTo Ending
    serial = Left(dat, j - 1)
    dat = Right(dat, Len(dat) - j)

    'set modified serial
    Mid(serial, 5, 1) = "B"
    modSerial = serial

    'warn firmware version
    MsgBox "FW version " + dat
    Exit Sub

Ending:
    Beep
End Sub

Private Sub cmdMod_Click()
    Dim s As String

    If MsgBox("are you sure your model and serial are correct?", vbYesNo) = vbNo Then Exit Sub

    'hack the model
    s = ":INFO:MODEL " + modModel
    SendRigolCommand s, -1
    Beep

    'hack the serial number
    s = ":INFO:SERIAL " + modSerial
    SendRigolCommand s, -1

    MsgBox "pls restart your scope and check info. see ya!"
    End
End Sub

Private Function SendRigolCommand(cmd As String, ByVal retLen As Long) As String

    'reserve to acquire the equipment ID.
    Dim matches As String * 200

    Dim defrm As Long
    Dim vi As Long
    Dim strRes As String * rigBufSize
    Dim list As Long
    Dim nmatches As Long
    Dim ret As String
    Dim i As Long

    'acquire USB resource of visa
    Call viOpenDefaultRM(defrm)
    Call viFindRsrc(defrm, "USB?*", list, nmatches, matches)

    'open the equipment
    Call viOpen(defrm, matches, 0, 0, vi)

    'send the command
    Call viVPrintf(vi, cmd + Chr(10), 0)

    'get the return value
    Call viVScanf(vi, "%t", strRes)

    'close the resource
    Call viClose(vi)
    Call viClose(defrm)

    If retLen > 0 Then
        ret = Left(strRes, retLen)
    Else
        retLen = InStr(1, strRes, Chr(0), vbBinaryCompare)
        If retLen > 0 Then
            ret = Left(strRes, retLen)
            
            For i = 1 To Len(ret)
                If Mid(ret, i, 1) = Chr(0) Then
                    Mid(ret, i, 1) = " "
                End If
            Next i
        End If
    End If

    SendRigolCommand = ret
End Function
